/*
	Copyright 2006-2026 The QElectroTech Team
	This file is part of QElectroTech.
	
	QElectroTech is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 2 of the License, or
	(at your option) any later version.
	
	QElectroTech is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with QElectroTech.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "qeticons.h"
#include <QApplication>

// on redeclare ici les icones
namespace QET {
	namespace Icons {
		QIcon Add;
		QIcon AddFolio;
		QIcon Allowed;
		QIcon ApplicationExit;
		QIcon ArrowLeft;
		QIcon ArrowLeftDouble;
		QIcon ArrowRight;
		QIcon ArrowRightDouble;
		QIcon Autoconnect;
		QIcon BringForward;
		QIcon Cancel;
		QIcon Company;
		QIcon Conductor;
		QIcon ConductorEdit;
		QIcon ConductorSettings;
		QIcon Configure;
		QIcon ConfigureToolbars;
		QIcon IC_CopyFile;
		QIcon DefaultConductor;
		QIcon DiagramAdd;
		QIcon Diagram;
		QIcon DiagramBg;
		QIcon DiagramDelete;
		QIcon DialogCancel;
		QIcon DialogInformation;
		QIcon DialogOk;
		QIcon DocumentClose;
		QIcon DocumentExport;
		QIcon DocumentSpreadsheet;
		QIcon DocumentImport;
		QIcon DocumentNew;
		QIcon DocumentOpen;
		QIcon DocumentOpenRecent;
		QIcon DocumentPrint;
		QIcon DocumentPrintFrame;
		QIcon DocumentSave;
		QIcon DocumentSaveAll;
		QIcon DocumentSaveAs;
		QIcon East;
		QIcon EditClear;
		QIcon EditClearLocationBar;
		QIcon EditCopy;
		QIcon EditCut;
		QIcon EditDelete;
		QIcon EditPaste;
		QIcon EditRedo;
		QIcon EditRename;
		QIcon EditSelectAll;
		QIcon EditSelectInvert;
		QIcon EditSelectNone;
		QIcon EditTableCellMerge;
		QIcon EditTableCellSplit;
		QIcon EditTableDeleteColumn;
		QIcon EditTableDeleteRow;
		QIcon EditTableInsertColumnLeft;
		QIcon EditTableInsertColumnRight;
		QIcon EditTableInsertRowAbove;
		QIcon EditTableInsertRowUnder;
		QIcon EditText;
		QIcon EditUndo;
		QIcon Element;
		QIcon ElementDelete;
		QIcon ElementEdit;
		QIcon ElementNew;
		QIcon ElementSmall;
		QIcon EndLineCircle;
		QIcon EndLineDiamond;
		QIcon EndLineNone;
		QIcon EndLineSimple;
		QIcon EndLineTriangle;
		QIcon EPS;
		QIcon Flip;
		QIcon Folder;
		QIcon FolderDelete;
		QIcon FolderEdit;
		QIcon FolderNew;
		QIcon FolderOnlyThis;
		QIcon FolderOpen;
		QIcon FolderProperties;
		QIcon FolderShowAll;
		QIcon Forbidden;
		QIcon FullScreenEnter;
		QIcon FullScreenExit;
		QIcon GoBottom;
		QIcon GoDown;
		QIcon GoDownDouble;
		QIcon GoTop;
		QIcon GoUp;
		QIcon GoUpDouble;
		QIcon Ground;
		QIcon Grid;
		QIcon Hide;
		QIcon Home;
		QIcon HotSpot;
		QIcon InsertImage;
		QIcon Lower;
		QIcon IC_MoveFile;
		QIcon Mirror;
		QIcon Names;
		QIcon Neutral;
		QIcon NewDiagram;
		QIcon North;
		QIcon ObjectLocked;
		QIcon ObjectRotateRight;
		QIcon ObjectUnlocked;
		QIcon Orientations;
		QIcon PartArc;
		QIcon PartCircle;
		QIcon PartEllipse;
		QIcon PartLine;
		QIcon PartPolygon;
		QIcon PartRectangle;
		QIcon PartSelect;
		QIcon PartText;
		QIcon PartTextField;
		QIcon PDF;
		QIcon Phase;
		QIcon PrintAllPages;
		QIcon Printer;
		QIcon PrintLandscape;
		QIcon PrintPortrait;
		QIcon PrintTwoPages;
		QIcon Project;
		QIcon ProjectClose;
		QIcon ProjectNew;
		QIcon Projects;
		QIcon ProjectFile;
		QIcon ProjectFileGP;
		QIcon ProjectProperties;
		QIcon QETIcon;
		QIcon QETLogo;
		QIcon QETOxygenLogo;
		QIcon QtLogo;
		QIcon Raise;
		QIcon Remove;
		QIcon Restore;
		QIcon RunDxf;
		QIcon SendBackward;
		QIcon Settings;
		QIcon SinglePage;
		QIcon South;
		QIcon Start;
		QIcon TableOfContent;
		QIcon Terminal;
		QIcon TitleBlock;
		QIcon TitleBlockBottom;
		QIcon TitleBlockRight;
		QIcon TransformRotate;
		QIcon UserInformations;
		QIcon ViewFitWidth;
		QIcon ViewFitWindow;
		QIcon ViewMove;
		QIcon ViewRefresh;
		QIcon West;
		QIcon WindowNew;
		QIcon XmlTextFile;
		QIcon ZoomDraw;
		QIcon ZoomFitBest;
		QIcon ZoomIn;
		QIcon ZoomOriginal;
		QIcon ZoomOut;
		QIcon adding_image;
		QIcon resize_image;
		QIcon sa;
		QIcon br;
		QIcon catalonia;
		QIcon cs;
		QIcon de;
		QIcon da;
		QIcon gr;
		QIcon en;
		QIcon es;
		QIcon fr;
		QIcon hr;
		QIcon hu;
		QIcon it;
		QIcon jp;
		QIcon pl;
		QIcon pt;
		QIcon ro;
		QIcon ru;
		QIcon sl;
		QIcon nl;
		QIcon no;
		QIcon nl_BE;
		QIcon tr;
		QIcon uk;
		QIcon mn;
		QIcon zh;
		QIcon se;
		QIcon translation;
		QIcon listDrawings;
		QIcon AutoNum;
		QIcon TerminalStrip;
		QIcon QETManual;
		QIcon QETDonate;
		QIcon QETDownload;
		QIcon QETVideo;
		QIcon super;
		QIcon sub;
		QIcon textGroup;
		QIcon ElementMaster;
		QIcon ElementSlave;
		QIcon FolioXrefComing;
		QIcon ElementTerminal;
		QIcon ColorBrown;
		QIcon ColorGray;
		QIcon ColorOrange;
		QIcon ColorPurple;
		QIcon ColorHTMLPinkPink;
		QIcon ColorHTMLPinkLightPink;
		QIcon ColorHTMLPinkHotPink;
		QIcon ColorHTMLPinkDeepPink;
		QIcon ColorHTMLPinkPaleVioletRed;
		QIcon ColorHTMLPinkMediumVioletRed;
		QIcon ColorHTMLRedLightSalmon;
		QIcon ColorHTMLRedSalmon;
		QIcon ColorHTMLRedDarkSalmon;
		QIcon ColorHTMLRedLightCoral;
		QIcon ColorHTMLRedIndianRed;
		QIcon ColorHTMLRedCrimson;
		QIcon ColorHTMLRedFirebrick;
		QIcon ColorHTMLRedDarkRed;
		QIcon ColorHTMLRedRed;
		QIcon ColorHTMLOrangeOrangeRed;
		QIcon ColorHTMLOrangeTomato;
		QIcon ColorHTMLOrangeCoral;
		QIcon ColorHTMLOrangeDarkOrange;
		QIcon ColorHTMLOrangeOrange;
		QIcon ColorHTMLYellowYellow;
		QIcon ColorHTMLYellowLightYellow;
		QIcon ColorHTMLYellowLemonChiffon;
		QIcon ColorHTMLYellowLightGoldenrodYellow;
		QIcon ColorHTMLYellowPapayaWhip;
		QIcon ColorHTMLYellowMoccasin;
		QIcon ColorHTMLYellowPeachPuff;
		QIcon ColorHTMLYellowPaleGoldenrod;
		QIcon ColorHTMLYellowKhaki;
		QIcon ColorHTMLYellowDarkKhaki;
		QIcon ColorHTMLYellowGold;
		QIcon ColorHTMLBrownCornsilk;
		QIcon ColorHTMLBrownBlanchedAlmond;
		QIcon ColorHTMLBrownBisque;
		QIcon ColorHTMLBrownNavajoWhite;
		QIcon ColorHTMLBrownWheat;
		QIcon ColorHTMLBrownBurlywood;
		QIcon ColorHTMLBrownTan;
		QIcon ColorHTMLBrownRosyBrown;
		QIcon ColorHTMLBrownSandyBrown;
		QIcon ColorHTMLBrownGoldenrod;
		QIcon ColorHTMLBrownDarkGoldenrod;
		QIcon ColorHTMLBrownPeru;
		QIcon ColorHTMLBrownChocolate;
		QIcon ColorHTMLBrownSaddleBrown;
		QIcon ColorHTMLBrownSienna;
		QIcon ColorHTMLBrownBrown;
		QIcon ColorHTMLBrownMaroon;
		QIcon ColorHTMLGreenDarkOliveGreen;
		QIcon ColorHTMLGreenOlive;
		QIcon ColorHTMLGreenOliveDrab;
		QIcon ColorHTMLGreenYellowGreen;
		QIcon ColorHTMLGreenLimeGreen;
		QIcon ColorHTMLGreenLime;
		QIcon ColorHTMLGreenLawnGreen;
		QIcon ColorHTMLGreenChartreuse;
		QIcon ColorHTMLGreenGreenYellow;
		QIcon ColorHTMLGreenSpringGreen;
		QIcon ColorHTMLGreenMediumSpringGreen;
		QIcon ColorHTMLGreenLightGreen;
		QIcon ColorHTMLGreenPaleGreen;
		QIcon ColorHTMLGreenDarkSeaGreen;
		QIcon ColorHTMLGreenMediumAquamarine;
		QIcon ColorHTMLGreenMediumSeaGreen;
		QIcon ColorHTMLGreenSeaGreen;
		QIcon ColorHTMLGreenForestGreen;
		QIcon ColorHTMLGreenGreen;
		QIcon ColorHTMLGreenDarkGreen;
		QIcon ColorHTMLCyanAqua;
		QIcon ColorHTMLCyanCyan;
		QIcon ColorHTMLCyanLightCyan;
		QIcon ColorHTMLCyanPaleTurquoise;
		QIcon ColorHTMLCyanAquamarine;
		QIcon ColorHTMLCyanTurquoise;
		QIcon ColorHTMLCyanMediumTurquoise;
		QIcon ColorHTMLCyanDarkTurquoise;
		QIcon ColorHTMLCyanLightSeaGreen;
		QIcon ColorHTMLCyanCadetBlue;
		QIcon ColorHTMLCyanDarkCyan;
		QIcon ColorHTMLCyanTeal;
		QIcon ColorHTMLBlueLightSteelBlue;
		QIcon ColorHTMLBluePowderBlue;
		QIcon ColorHTMLBlueLightBlue;
		QIcon ColorHTMLBlueSkyBlue;
		QIcon ColorHTMLBlueLightSkyBlue;
		QIcon ColorHTMLBlueDeepSkyBlue;
		QIcon ColorHTMLBlueDodgerBlue;
		QIcon ColorHTMLBlueCornflowerBlue;
		QIcon ColorHTMLBlueSteelBlue;
		QIcon ColorHTMLBlueRoyalBlue;
		QIcon ColorHTMLBlueBlue;
		QIcon ColorHTMLBlueMediumBlue;
		QIcon ColorHTMLBlueDarkBlue;
		QIcon ColorHTMLBlueNavy;
		QIcon ColorHTMLBlueMidnightBlue;
		QIcon ColorHTMLPurpleLavender;
		QIcon ColorHTMLPurpleThistle;
		QIcon ColorHTMLPurplePlum;
		QIcon ColorHTMLPurpleViolet;
		QIcon ColorHTMLPurpleOrchid;
		QIcon ColorHTMLPurpleFuchsia;
		QIcon ColorHTMLPurpleMagenta;
		QIcon ColorHTMLPurpleMediumOrchid;
		QIcon ColorHTMLPurpleMediumPurple;
		QIcon ColorHTMLPurpleBlueViolet;
		QIcon ColorHTMLPurpleDarkViolet;
		QIcon ColorHTMLPurpleDarkOrchid;
		QIcon ColorHTMLPurpleDarkMagenta;
		QIcon ColorHTMLPurplePurple;
		QIcon ColorHTMLPurpleIndigo;
		QIcon ColorHTMLPurpleDarkSlateBlue;
		QIcon ColorHTMLPurpleSlateBlue;
		QIcon ColorHTMLPurpleMediumSlateBlue;
		QIcon ColorHTMLWhiteWhite;
		QIcon ColorHTMLWhiteSnow;
		QIcon ColorHTMLWhiteHoneydew;
		QIcon ColorHTMLWhiteMintCream;
		QIcon ColorHTMLWhiteAzure;
		QIcon ColorHTMLWhiteAliceBlue;
		QIcon ColorHTMLWhiteGhostWhite;
		QIcon ColorHTMLWhiteWhiteSmoke;
		QIcon ColorHTMLWhiteSeashell;
		QIcon ColorHTMLWhiteBeige;
		QIcon ColorHTMLWhiteOldLace;
		QIcon ColorHTMLWhiteFloralWhite;
		QIcon ColorHTMLWhiteIvory;
		QIcon ColorHTMLWhiteAntiqueWhite;
		QIcon ColorHTMLWhiteLinen;
		QIcon ColorHTMLWhiteLavenderBlush;
		QIcon ColorHTMLWhiteMistyRose;
		QIcon ColorHTMLGrayGainsboro;
		QIcon ColorHTMLGrayLightGray;
		QIcon ColorHTMLGraySilver;
		QIcon ColorHTMLGrayDarkGray;
		QIcon ColorHTMLGrayGray;
		QIcon ColorHTMLGrayDimGray;
		QIcon ColorHTMLGrayLightSlateGray;
		QIcon ColorHTMLGraySlateGray;
		QIcon ColorHTMLGrayDarkSlateGray;
		QIcon ColorHTMLGrayBlack;
	}
}

/**
	Initialise les icones de l'application QElectroTech
*/
void QET::Icons::initIcons()
{
	// we may need to mirror some icons for right-to-left languages
	bool rtl = QApplication::isRightToLeft();
	QTransform reverse = QTransform().scale(-1, 1);
	
	Add                 .addFile(":/ico/16x16/list-add.png");
	Add                 .addFile(":/ico/22x22/list-add.png");
	AddFolio            .addFile(":/ico/16x16/folio-new.png");
	Allowed             .addFile(":/ico/16x16/user-online.png");
	ApplicationExit     .addFile(":/ico/16x16/application-exit.png");
	ApplicationExit     .addFile(":/ico/22x22/application-exit.png");
	ArrowLeft           .addFile(":/ico/16x16/arrow-left.png");
	ArrowLeft           .addFile(":/ico/22x22/arrow-left.png");
	ArrowLeftDouble     .addFile(":/ico/16x16/arrow-left-double.png");
	ArrowLeftDouble     .addFile(":/ico/22x22/arrow-left-double.png");
	ArrowRight          .addFile(":/ico/16x16/arrow-right.png");
	ArrowRight          .addFile(":/ico/22x22/arrow-right.png");
	ArrowRightDouble    .addFile(":/ico/16x16/arrow-right-double.png");
	ArrowRightDouble    .addFile(":/ico/22x22/arrow-right-double.png");
	Autoconnect         .addFile(":/ico/22x22/autoconnect.png");
	BringForward        .addFile(":/ico/22x22/bring_forward.png");
	Cancel              .addFile(":/ico/16x16/item-cancel.png");
	Company             .addFile(":/ico/16x16/go-company.png");
	Company             .addFile(":/ico/22x22/go-company.png");
	Conductor           .addFile(":/ico/16x16/conductor.png");
	ConductorEdit       .addFile(":/ico/16x16/conductor-edit.png");
	ConductorSettings   .addFile(":/ico/16x16/conductor-reset.png");
	ConductorSettings   .addFile(":/ico/22x22/conductor2.png");
	Configure           .addFile(":/ico/16x16/configure.png");
	Configure           .addFile(":/ico/22x22/configure.png");
	ConfigureToolbars   .addFile(":/ico/16x16/configure-toolbars.png");
	ConfigureToolbars   .addFile(":/ico/22x22/configure-toolbars.png");
	IC_CopyFile            .addFile(":/ico/16x16/item-copy.png");
	DiagramAdd          .addFile(":/ico/16x16/folio-new.png");
	DiagramAdd          .addFile(":/ico/22x22/diagram_add.png");
	Diagram             .addFile(":/ico/16x16/diagram.png");
	Diagram             .addFile(":/ico/diagram.png");
	DiagramBg           .addFile(":/ico/22x22/diagram_bg.png");
	DiagramDelete       .addFile(":/ico/16x16/folio-delete.png");
	DiagramDelete       .addFile(":/ico/22x22/diagram_del.png");
	DialogCancel        .addFile(":/ico/16x16/dialog-cancel.png");
	DialogCancel        .addFile(":/ico/22x22/dialog-cancel.png");
	DialogInformation   .addFile(":/ico/16x16/folio-properties.png");
	DialogInformation   .addFile(":/ico/22x22/dialog-information.png");
	DialogOk            .addFile(":/ico/16x16/dialog-ok.png");
	DialogOk            .addFile(":/ico/22x22/dialog-ok.png");
	DocumentClose       .addFile(":/ico/16x16/document-close.png");
	DocumentClose       .addFile(":/ico/22x22/document-close.png");
	DocumentExport      .addFile(":/ico/16x16/document-export.png");
	DocumentExport      .addFile(":/ico/22x22/document-export.png");
	DocumentSpreadsheet .addFile(":/ico/16x16/export-csv.png");
	DocumentExport      .addFile(":/ico/128x128/document-export.png");
	DocumentImport      .addFile(":/ico/16x16/document-import.png");
	DocumentImport      .addFile(":/ico/22x22/document-import.png");
	DocumentNew         .addFile(":/ico/16x16/document-new.png");
	DocumentNew         .addFile(":/ico/22x22/document-new.png");
	DocumentOpen        .addFile(":/ico/16x16/document-open.png");
	DocumentOpen        .addFile(":/ico/22x22/document-open.png");
	DocumentOpenRecent  .addFile(":/ico/16x16/document-open-recent.png");
	DocumentOpenRecent  .addFile(":/ico/22x22/document-open-recent.png");
	DocumentPrint       .addFile(":/ico/16x16/document-print.png");
	DocumentPrint       .addFile(":/ico/22x22/document-print.png");
	DocumentPrintFrame  .addFile(":/ico/16x16/document-print-frame.png");
	DocumentPrintFrame  .addFile(":/ico/48x48/document-print-frame.png");
	DocumentSave        .addFile(":/ico/16x16/document-save.png");
	DocumentSave        .addFile(":/ico/22x22/document-save.png");
	DocumentSaveAll     .addFile(":/ico/16x16/document-save-all.png");
	DocumentSaveAll     .addFile(":/ico/22x22/document-save-all.png");
	DocumentSaveAs      .addFile(":/ico/16x16/document-save-as.png");
	DocumentSaveAs      .addFile(":/ico/22x22/document-save-as.png");
	East                .addFile(":/ico/16x16/east.png");
	EditClear           .addFile(":/ico/16x16/edit-clear.png");
	EditClear           .addFile(":/ico/22x22/edit-clear.png");
	EditText            .addFile(":/ico/22x22/names.png");
	adding_image        .addFile(":/ico/22x22/insert-image.png");
	
	if (rtl) {
		EditClearLocationBar.addPixmap(QPixmap(":/ico/16x16/edit-clear-locationbar-ltr.png").transformed(reverse));
		EditClearLocationBar.addPixmap(QPixmap(":/ico/22x22/edit-clear-locationbar-ltr.png").transformed(reverse));
	} else {
		EditClearLocationBar.addFile(":/ico/16x16/edit-clear-locationbar-ltr.png");
		EditClearLocationBar.addFile(":/ico/22x22/edit-clear-locationbar-ltr.png");
	}
	EditCopy            .addFile(":/ico/16x16/edit-copy.png");
	EditCopy            .addFile(":/ico/22x22/edit-copy.png");
	EditCut             .addFile(":/ico/16x16/edit-cut.png");
	EditCut             .addFile(":/ico/22x22/edit-cut.png");
	EditDelete          .addFile(":/ico/16x16/edit-delete.png");
	EditDelete          .addFile(":/ico/22x22/edit-delete.png");
	EditPaste           .addFile(":/ico/22x22/edit-paste.png");
	EditPaste           .addFile(":/ico/16x16/edit-paste.png");
	if (rtl) {
		EditRedo.addPixmap(QPixmap(":/ico/16x16/edit-redo.png").transformed(reverse));
		EditRedo.addPixmap(QPixmap(":/ico/22x22/edit-redo.png").transformed(reverse));
	} else {
		EditRedo            .addFile(":/ico/16x16/edit-redo.png");
		EditRedo            .addFile(":/ico/22x22/edit-redo.png");
	}
	EditRename                .addFile(":/ico/16x16/edit-rename.png");
	EditRename                .addFile(":/ico/22x22/edit-rename.png");
	EditSelectAll             .addFile(":/ico/16x16/edit-select-all.png");
	EditSelectAll             .addFile(":/ico/22x22/edit-select-all.png");
	EditSelectInvert          .addFile(":/ico/16x16/edit-select-invert.png");
	EditSelectNone            .addFile(":/ico/16x16/edit-select-none.png");
	EditTableCellMerge        .addFile(":/ico/16x16/edit-table-cell-merge.png");
	EditTableCellMerge        .addFile(":/ico/22x22/edit-table-cell-merge.png");
	EditTableCellSplit        .addFile(":/ico/16x16/edit-table-cell-split.png");
	EditTableCellSplit        .addFile(":/ico/22x22/edit-table-cell-split.png");
	EditTableDeleteColumn     .addFile(":/ico/16x16/edit-table-delete-column.png");
	EditTableDeleteColumn     .addFile(":/ico/22x22/edit-table-delete-column.png");
	EditTableDeleteRow        .addFile(":/ico/16x16/edit-table-delete-row.png");
	EditTableDeleteRow        .addFile(":/ico/22x22/edit-table-delete-row.png");
	EditTableInsertColumnLeft .addFile(":/ico/16x16/edit-table-insert-column-left.png");
	EditTableInsertColumnLeft .addFile(":/ico/22x22/edit-table-insert-column-left.png");
	EditTableInsertColumnRight.addFile(":/ico/16x16/edit-table-insert-column-right.png");
	EditTableInsertColumnRight.addFile(":/ico/22x22/edit-table-insert-column-right.png");
	EditTableInsertRowAbove   .addFile(":/ico/16x16/edit-table-insert-row-above.png");
	EditTableInsertRowAbove   .addFile(":/ico/22x22/edit-table-insert-row-above.png");
	EditTableInsertRowUnder   .addFile(":/ico/16x16/edit-table-insert-row-under.png");
	EditTableInsertRowUnder   .addFile(":/ico/22x22/edit-table-insert-row-under.png");
	if (rtl) {
		EditUndo.addPixmap(QPixmap(":/ico/16x16/edit-undo.png").transformed(reverse));
		EditUndo.addPixmap(QPixmap(":/ico/22x22/edit-undo.png").transformed(reverse));
	} else {
		EditUndo            .addFile(":/ico/16x16/edit-undo.png");
		EditUndo            .addFile(":/ico/22x22/edit-undo.png");
	}
	Element             .addFile(":/ico/breeze-icons/16x16/mimetypes/application-x-qet-element.png");
	Element             .addFile(":/ico/breeze-icons/22x22/mimetypes/application-x-qet-element.png");
	Element             .addFile(":/ico/breeze-icons/32x32/mimetypes/application-x-qet-element.png");
	ElementDelete       .addFile(":/ico/16x16/element-delete.png");
	ElementDelete       .addFile(":/ico/22x22/element-delete.png");
	ElementEdit         .addFile(":/ico/16x16/element-edit.png");
	ElementEdit         .addFile(":/ico/22x22/element-edit.png");
	ElementNew          .addFile(":/ico/16x16/element-new.png");
	ElementNew          .addFile(":/ico/22x22/element-new.png");
	ElementSmall        .addFile(":/ico/16x16/element.png");
	EndLineCircle       .addFile(":/ico/16x16/endline-circle.png");
	EndLineDiamond      .addFile(":/ico/16x16/endline-diamond.png");
	EndLineNone         .addFile(":/ico/16x16/endline-none.png");
	EndLineSimple       .addFile(":/ico/16x16/endline-simple.png");
	EndLineTriangle     .addFile(":/ico/16x16/endline-triangle.png");
	EPS                 .addFile(":/ico/32x32/image-x-eps.png");
	Flip                .addFile(":/ico/16x16/flip.png");
	Folder              .addFile(":/ico/16x16/folder.png");
	FolderDelete        .addFile(":/ico/16x16/folder-delete.png");
	FolderDelete        .addFile(":/ico/22x22/folder-delete.png");
	FolderEdit          .addFile(":/ico/16x16/folder-edit.png");
	FolderEdit          .addFile(":/ico/22x22/folder-edit.png");
	FolderNew           .addFile(":/ico/16x16/folder-new.png");
	FolderNew           .addFile(":/ico/22x22/folder-new.png");
	FolderOnlyThis      .addFile(":/ico/16x16/folder-only-this.png");
	FolderOpen          .addFile(":/ico/16x16/folder-open.png");
	FolderOpen          .addFile(":/ico/22x22/folder-open.png");
	FolderProperties    .addFile(":/ico/16x16/folder-properties.png");
	FolderShowAll       .addFile(":/ico/16x16/folder-show-all.png");
	Forbidden           .addFile(":/ico/16x16/user-busy.png");
	FullScreenEnter     .addFile(":/ico/16x16/view-fullscreen.png");
	FullScreenEnter     .addFile(":/ico/22x22/view-fullscreen.png");
	FullScreenExit      .addFile(":/ico/16x16/view-restore.png");
	FullScreenExit      .addFile(":/ico/22x22/view-restore.png");
	GoBottom            .addFile(":/ico/16x16/go-bottom.png");
	GoDown              .addFile(":/ico/16x16/go-down.png");
	GoDown              .addFile(":/ico/22x22/go-down.png");
	GoDownDouble        .addFile(":/ico/16x16/go-down-double.png");
	GoTop               .addFile(":/ico/16x16/go-top.png");
	GoUp                .addFile(":/ico/16x16/go-up.png");
	GoUp                .addFile(":/ico/22x22/go-up.png");
	GoUpDouble          .addFile(":/ico/16x16/go-up-double.png");
	Ground              .addFile(":/ico/16x16/ground.png");
	Grid                .addFile(":/ico/16x16/grid.png");
	Grid                .addFile(":/ico/22x22/grid.png");
	Hide                .addFile(":/ico/16x16/masquer.png");
	Home                .addFile(":/ico/16x16/go-home.png");
	Home                .addFile(":/ico/22x22/go-home.png");
	HotSpot             .addFile(":/ico/22x22/hotspot.png");
	InsertImage         .addFile(":/ico/22x22/insert-image.png");
	Lower               .addFile(":/ico/22x22/lower.png");
	IC_MoveFile         .addFile(":/ico/16x16/item-move.png");
	Mirror              .addFile(":/ico/16x16/mirror.png");
	Names               .addFile(":/ico/22x22/names.png");
	Neutral             .addFile(":/ico/16x16/neutral.png");
	NewDiagram          .addFile(":/ico/128x128/diagram.png");
	North               .addFile(":/ico/16x16/north.png");
	ObjectLocked        .addFile(":/ico/22x22/object-locked.png");
	ObjectRotateRight   .addFile(":/ico/16x16/object-rotate-right.png");
	ObjectRotateRight   .addFile(":/ico/22x22/object-rotate-right.png");
	ObjectUnlocked      .addFile(":/ico/22x22/object-unlocked.png");
	Orientations        .addFile(":/ico/16x16/orientations.png");
	PartArc             .addFile(":/ico/22x22/arc.png");
	PartCircle          .addFile(":/ico/16x16/circle.png");
	PartEllipse         .addFile(":/ico/22x22/ellipse.png");
	PartLine            .addFile(":/ico/22x22/line.png");
	PartPolygon         .addFile(":/ico/22x22/polygon.png");
	PartRectangle       .addFile(":/ico/22x22/rectangle.png");
	PartSelect          .addFile(":/ico/16x16/select.png");
	PartSelect          .addFile(":/ico/22x22/select.png");
	PartText            .addFile(":/ico/22x22/text.png");
	PartTextField       .addFile(":/ico/22x22/textfield.png");
	PDF                 .addFile(":/ico/32x32/application-pdf.png");
	Phase               .addFile(":/ico/16x16/phase.png");
	PrintAllPages       .addFile(":/ico/22x22/all_pages.png");
	Printer             .addFile(":/ico/32x32/printer.png");
	Printer             .addFile(":/ico/128x128/printer.png");
	PrintLandscape      .addFile(":/ico/22x22/landscape.png");
	PrintPortrait       .addFile(":/ico/22x22/portrait.png");
	PrintTwoPages       .addFile(":/ico/22x22/two_pages.png");
	Projects            .addFile(":/ico/128x128/project.png");
	ProjectClose        .addFile(":/ico/16x16/project-close.png");
	ProjectClose        .addFile(":/ico/22x22/project-close.png");
	ProjectNew          .addFile(":/ico/16x16/project-new.png");
	ProjectNew          .addFile(":/ico/22x22/project-new.png");
	ProjectFile         .addFile(":/ico/breeze-icons/16x16/mimetypes/application-x-qet-project.png");
	ProjectFile         .addFile(":/ico/breeze-icons/22x22/mimetypes/application-x-qet-project.png");
	ProjectFile         .addFile(":/ico/breeze-icons/32x32/mimetypes/application-x-qet-project.png");
	ProjectProperties   .addFile(":/ico/16x16/project-properties.png");
	QETDonate           .addFile(":/ico/16x16/help-donate.png");
	QETDownload         .addFile(":/ico/16x16/edit-download.png");
	QETIcon             .addFile(":/ico/256x256/qelectrotech.png");
	ProjectFileGP       .addFile(":/ico/16x16/project.png");
	QETLogo             .addFile(":/ico/16x16/qet.png");
	QETManual           .addFile(":/ico/16x16/help-contents.png");
	QETLogo             .addFile(":/ico/256x256/qet.png");
	QETOxygenLogo       .addFile(":/ico/breeze-icons/128x128/apps/qelectrotech.png");
	QETOxygenLogo       .addFile(":/ico/breeze-icons/16x16/apps/qelectrotech.png");
	QETOxygenLogo       .addFile(":/ico/breeze-icons/22x22/apps/qelectrotech.png");
	QETOxygenLogo       .addFile(":/ico/breeze-icons/256x256/apps/qelectrotech.png");
	QETOxygenLogo       .addFile(":/ico/breeze-icons/32x32/apps/qelectrotech.png");
	QETOxygenLogo       .addFile(":/ico/breeze-icons/48x48/apps/qelectrotech.png");
	QETOxygenLogo       .addFile(":/ico/breeze-icons/64x64/apps/qelectrotech.png");
	QETVideo            .addFile(":/ico/16x16/kdenlive-show-video.png");
	QtLogo              .addFile(":/ico/16x16/qt.png");
	Raise               .addFile(":/ico/22x22/raise.png");
	Remove              .addFile(":/ico/16x16/list-remove.png");
	Remove              .addFile(":/ico/22x22/list-remove.png");
	resize_image        .addFile(":/ico/22x22/transform-scale.png");
	Restore             .addFile(":/ico/22x22/restaurer.png");
	RunDxf              .addFile(":/ico/16x16/run-dxf.png");
	SendBackward        .addFile(":/ico/22x22/send_backward.png");
	Settings            .addFile(":/ico/128x128/settings.png");
	SinglePage          .addFile(":/ico/22x22/single_page.png");
	South               .addFile(":/ico/16x16/south.png");
	Start               .addFile(":/ico/22x22/start.png");
	TableOfContent      .addFile(":/ico/16x16/table-of-content.png");
	Terminal            .addFile(":/ico/22x22/terminal.png");
	TerminalStrip       .addFile(":/ico/16x16/terminalstrip.png");
	TerminalStrip       .addFile(":/ico/22x22/terminalstrip.png");
	TitleBlock          .addFile(":/ico/16x16/label.png");
	TitleBlock          .addFile(":/ico/22x22/label.png");
	TitleBlockBottom    .addFile(":/ico/22x22/titleblock-bottom.png");
	TitleBlockRight     .addFile(":/ico/22x22/titleblock-right.png");
	TransformRotate     .addFile(":/ico/16x16/transform-rotate.png");
	UserInformations    .addFile(":/ico/16x16/preferences-desktop-user.png");
	UserInformations    .addFile(":/ico/22x22/preferences-desktop-user.png");
	ViewFitWidth        .addFile(":/ico/22x22/view_fit_width.png");
	ViewFitWindow       .addFile(":/ico/22x22/view-fit-window.png");
	ViewMove            .addFile(":/ico/16x16/move.png");
	ViewMove            .addFile(":/ico/22x22/move.png");
	if (rtl) {
		ViewRefresh.addPixmap(QPixmap(":/ico/16x16/view-refresh.png").transformed(reverse));
		ViewRefresh.addPixmap(QPixmap(":/ico/22x22/view-refresh.png").transformed(reverse));
	} else {
		ViewRefresh         .addFile(":/ico/16x16/view-refresh.png");
		ViewRefresh         .addFile(":/ico/22x22/view-refresh.png");
	}
	West                .addFile(":/ico/16x16/west.png");
	WindowNew           .addFile(":/ico/16x16/window-new.png");
	WindowNew           .addFile(":/ico/22x22/window-new.png");
	XmlTextFile         .addFile(":/ico/16x16/text-xml.png");
	XmlTextFile         .addFile(":/ico/22x22/text-xml.png");
	XmlTextFile         .addFile(":/ico/32x32/text-xml.png");
	ZoomDraw            .addFile(":/ico/16x16/zoom-draw.png");
	ZoomDraw            .addFile(":/ico/22x22/zoom-draw.png");
	ZoomFitBest         .addFile(":/ico/16x16/zoom-fit-best.png");
	ZoomFitBest         .addFile(":/ico/22x22/zoom-fit-best.png");
	ZoomIn              .addFile(":/ico/16x16/zoom-in.png");
	ZoomIn              .addFile(":/ico/22x22/zoom-in.png");
	ZoomOriginal        .addFile(":/ico/16x16/zoom-original.png");
	ZoomOriginal        .addFile(":/ico/22x22/zoom-original.png");
	ZoomOut             .addFile(":/ico/16x16/zoom-out.png");
	ZoomOut             .addFile(":/ico/22x22/zoom-out.png");
	sa                  .addFile(":/ico/24x16/sa.png");
	br                  .addFile(":/ico/24x16/br.png");
	catalonia           .addFile(":/ico/24x16/catalonia.png");
	cs                  .addFile(":/ico/24x16/cs.png");
	da                  .addFile(":/ico/24x16/dk.png");
	de                  .addFile(":/ico/24x16/de.png");
	gr                  .addFile(":/ico/24x16/gr.png");
	en                  .addFile(":/ico/24x16/en.png");
	es                  .addFile(":/ico/24x16/es.png");
	fr                  .addFile(":/ico/24x16/fr.png");
	hr                  .addFile(":/ico/24x16/hr.png");
	hu                  .addFile(":/ico/24x16/hu.png");
	it                  .addFile(":/ico/24x16/it.png");
	jp                  .addFile(":/ico/24x16/jp.png");
	pl                  .addFile(":/ico/24x16/pl.png");
	pt                  .addFile(":/ico/24x16/pt.png");
	ro                  .addFile(":/ico/24x16/ro.png");
	ru                  .addFile(":/ico/24x16/ru.png");
	sl                  .addFile(":/ico/24x16/sl.png");
	nl                  .addFile(":/ico/24x16/nl.png");
	no                  .addFile(":/ico/24x16/no.png");
	nl_BE               .addFile(":/ico/24x16/nl_BE.png");
	tr                  .addFile(":/ico/24x16/tr.png");
	uk                  .addFile(":/ico/24x16/ua.png");
	mn                  .addFile(":/ico/24x16/mn.png");
	zh                  .addFile(":/ico/24x16/zh.png");
	se                  .addFile(":/ico/24x16/se.png");
	translation         .addFile(":/ico/22x22/applications-development-translation.png");
	listDrawings        .addFile(":/ico/48x48/view-pim-journal.png");
	AutoNum             .addFile(":/ico/128x128/plasmagik.png");
	sub                 .addFile(":/ico/22x22/format-text-subscript.png");
	super               .addFile(":/ico/22x22/format-text-superscript.png");
	textGroup           .addFile(":/ico/16x16/object-group.png");
	ElementMaster       .addFile(":/ico/16x16/element-master.png");
	ElementSlave        .addFile(":/ico/16x16/element-slave.png");
	FolioXrefComing     .addFile(":/ico/16x16/folio-ref-coming.png");
	ElementTerminal     .addFile(":/ico/16x16/terminal.png");
	ColorBrown                         .addFile(":/ico/22x22/color/color-brown.png");
	ColorGray                          .addFile(":/ico/22x22/color/color-gray.png");
	ColorOrange                        .addFile(":/ico/22x22/color/color-orange.png");
	ColorPurple                        .addFile(":/ico/22x22/color/color-purple.png");
	ColorHTMLPinkPink                  .addFile(":/ico/22x22/color/color-01-pink-01-pink.png");
	ColorHTMLPinkLightPink             .addFile(":/ico/22x22/color/color-01-pink-02-lightpink.png");
	ColorHTMLPinkHotPink               .addFile(":/ico/22x22/color/color-01-pink-03-hotpink.png");
	ColorHTMLPinkDeepPink              .addFile(":/ico/22x22/color/color-01-pink-04-deeppink.png");
	ColorHTMLPinkPaleVioletRed         .addFile(":/ico/22x22/color/color-01-pink-05-palevioletred.png");
	ColorHTMLPinkMediumVioletRed       .addFile(":/ico/22x22/color/color-01-pink-06-mediumvioletred.png");
	ColorHTMLRedLightSalmon            .addFile(":/ico/22x22/color/color-02-red-01-lightsalmon.png");
	ColorHTMLRedSalmon                 .addFile(":/ico/22x22/color/color-02-red-02-salmon.png");
	ColorHTMLRedDarkSalmon             .addFile(":/ico/22x22/color/color-02-red-03-darksalmon.png");
	ColorHTMLRedLightCoral             .addFile(":/ico/22x22/color/color-02-red-04-lightcoral.png");
	ColorHTMLRedIndianRed              .addFile(":/ico/22x22/color/color-02-red-05-indianred.png");
	ColorHTMLRedCrimson                .addFile(":/ico/22x22/color/color-02-red-06-crimson.png");
	ColorHTMLRedFirebrick              .addFile(":/ico/22x22/color/color-02-red-07-firebrick.png");
	ColorHTMLRedDarkRed                .addFile(":/ico/22x22/color/color-02-red-08-darkred.png");
	ColorHTMLRedRed                    .addFile(":/ico/22x22/color/color-02-red-09-red.png");
	ColorHTMLOrangeOrangeRed           .addFile(":/ico/22x22/color/color-03-orange-01-orangered.png");
	ColorHTMLOrangeTomato              .addFile(":/ico/22x22/color/color-03-orange-02-tomato.png");
	ColorHTMLOrangeCoral               .addFile(":/ico/22x22/color/color-03-orange-03-coral.png");
	ColorHTMLOrangeDarkOrange          .addFile(":/ico/22x22/color/color-03-orange-04-darkorange.png");
	ColorHTMLOrangeOrange              .addFile(":/ico/22x22/color/color-03-orange-05-orange.png");
	ColorHTMLYellowYellow              .addFile(":/ico/22x22/color/color-04-yellow-01-yellow.png");
	ColorHTMLYellowLightYellow         .addFile(":/ico/22x22/color/color-04-yellow-02-lightyellow.png");
	ColorHTMLYellowLemonChiffon        .addFile(":/ico/22x22/color/color-04-yellow-03-lemonchiffon.png");
	ColorHTMLYellowLightGoldenrodYellow.addFile(":/ico/22x22/color/color-04-yellow-04-lightgoldenrodyellow.png");
	ColorHTMLYellowPapayaWhip          .addFile(":/ico/22x22/color/color-04-yellow-05-papayawhip.png");
	ColorHTMLYellowMoccasin            .addFile(":/ico/22x22/color/color-04-yellow-06-moccasin.png");
	ColorHTMLYellowPeachPuff           .addFile(":/ico/22x22/color/color-04-yellow-07-peachpuff.png");
	ColorHTMLYellowPaleGoldenrod       .addFile(":/ico/22x22/color/color-04-yellow-08-palegoldenrod.png");
	ColorHTMLYellowKhaki               .addFile(":/ico/22x22/color/color-04-yellow-09-khaki.png");
	ColorHTMLYellowDarkKhaki           .addFile(":/ico/22x22/color/color-04-yellow-10-darkkhaki.png");
	ColorHTMLYellowGold                .addFile(":/ico/22x22/color/color-04-yellow-11-gold.png");
	ColorHTMLBrownCornsilk             .addFile(":/ico/22x22/color/color-05-brown-01-cornsilk.png");
	ColorHTMLBrownBlanchedAlmond       .addFile(":/ico/22x22/color/color-05-brown-02-blanchedalmond.png");
	ColorHTMLBrownBisque               .addFile(":/ico/22x22/color/color-05-brown-03-bisque.png");
	ColorHTMLBrownNavajoWhite          .addFile(":/ico/22x22/color/color-05-brown-04-navajowhite.png");
	ColorHTMLBrownWheat                .addFile(":/ico/22x22/color/color-05-brown-05-wheat.png");
	ColorHTMLBrownBurlywood            .addFile(":/ico/22x22/color/color-05-brown-06-burlywood.png");
	ColorHTMLBrownTan                  .addFile(":/ico/22x22/color/color-05-brown-07-tan.png");
	ColorHTMLBrownRosyBrown            .addFile(":/ico/22x22/color/color-05-brown-08-rosybrown.png");
	ColorHTMLBrownSandyBrown           .addFile(":/ico/22x22/color/color-05-brown-09-sandybrown.png");
	ColorHTMLBrownGoldenrod            .addFile(":/ico/22x22/color/color-05-brown-10-goldenrod.png");
	ColorHTMLBrownDarkGoldenrod        .addFile(":/ico/22x22/color/color-05-brown-11-darkgoldenrod.png");
	ColorHTMLBrownPeru                 .addFile(":/ico/22x22/color/color-05-brown-12-peru.png");
	ColorHTMLBrownChocolate            .addFile(":/ico/22x22/color/color-05-brown-13-chocolate.png");
	ColorHTMLBrownSaddleBrown          .addFile(":/ico/22x22/color/color-05-brown-14-saddlebrown.png");
	ColorHTMLBrownSienna               .addFile(":/ico/22x22/color/color-05-brown-15-sienna.png");
	ColorHTMLBrownBrown                .addFile(":/ico/22x22/color/color-05-brown-16-brown.png");
	ColorHTMLBrownMaroon               .addFile(":/ico/22x22/color/color-05-brown-17-maroon.png");
	ColorHTMLGreenDarkOliveGreen       .addFile(":/ico/22x22/color/color-06-green-01-darkolivegreen.png");
	ColorHTMLGreenOlive                .addFile(":/ico/22x22/color/color-06-green-02-olive.png");
	ColorHTMLGreenOliveDrab            .addFile(":/ico/22x22/color/color-06-green-03-olivedrab.png");
	ColorHTMLGreenYellowGreen          .addFile(":/ico/22x22/color/color-06-green-04-yellowgreen.png");
	ColorHTMLGreenLimeGreen            .addFile(":/ico/22x22/color/color-06-green-05-limegreen.png");
	ColorHTMLGreenLime                 .addFile(":/ico/22x22/color/color-06-green-06-lime.png");
	ColorHTMLGreenLawnGreen            .addFile(":/ico/22x22/color/color-06-green-07-lawngreen.png");
	ColorHTMLGreenChartreuse           .addFile(":/ico/22x22/color/color-06-green-08-chartreuse.png");
	ColorHTMLGreenGreenYellow          .addFile(":/ico/22x22/color/color-06-green-09-greenyellow.png");
	ColorHTMLGreenSpringGreen          .addFile(":/ico/22x22/color/color-06-green-10-springgreen.png");
	ColorHTMLGreenMediumSpringGreen    .addFile(":/ico/22x22/color/color-06-green-11-mediumspringgreen.png");
	ColorHTMLGreenLightGreen           .addFile(":/ico/22x22/color/color-06-green-12-lightgreen.png");
	ColorHTMLGreenPaleGreen            .addFile(":/ico/22x22/color/color-06-green-13-palegreen.png");
	ColorHTMLGreenDarkSeaGreen         .addFile(":/ico/22x22/color/color-06-green-14-darkseagreen.png");
	ColorHTMLGreenMediumAquamarine     .addFile(":/ico/22x22/color/color-06-green-15-mediumaquamarine.png");
	ColorHTMLGreenMediumSeaGreen       .addFile(":/ico/22x22/color/color-06-green-16-mediumseagreen.png");
	ColorHTMLGreenSeaGreen             .addFile(":/ico/22x22/color/color-06-green-17-seagreen.png");
	ColorHTMLGreenForestGreen          .addFile(":/ico/22x22/color/color-06-green-18-forestgreen.png");
	ColorHTMLGreenGreen                .addFile(":/ico/22x22/color/color-06-green-19-green.png");
	ColorHTMLGreenDarkGreen            .addFile(":/ico/22x22/color/color-06-green-20-darkgreen.png");
	ColorHTMLCyanAqua                  .addFile(":/ico/22x22/color/color-07-cyan-01-aqua.png");
	ColorHTMLCyanCyan                  .addFile(":/ico/22x22/color/color-07-cyan-02-cyan.png");
	ColorHTMLCyanLightCyan             .addFile(":/ico/22x22/color/color-07-cyan-03-lightcyan.png");
	ColorHTMLCyanPaleTurquoise         .addFile(":/ico/22x22/color/color-07-cyan-04-paleturquoise.png");
	ColorHTMLCyanAquamarine            .addFile(":/ico/22x22/color/color-07-cyan-05-aquamarine.png");
	ColorHTMLCyanTurquoise             .addFile(":/ico/22x22/color/color-07-cyan-06-turquoise.png");
	ColorHTMLCyanMediumTurquoise       .addFile(":/ico/22x22/color/color-07-cyan-07-mediumturquoise.png");
	ColorHTMLCyanDarkTurquoise         .addFile(":/ico/22x22/color/color-07-cyan-08-darkturquoise.png");
	ColorHTMLCyanLightSeaGreen         .addFile(":/ico/22x22/color/color-07-cyan-09-lightseagreen.png");
	ColorHTMLCyanCadetBlue             .addFile(":/ico/22x22/color/color-07-cyan-10-cadetblue.png");
	ColorHTMLCyanDarkCyan              .addFile(":/ico/22x22/color/color-07-cyan-11-darkcyan.png");
	ColorHTMLCyanTeal                  .addFile(":/ico/22x22/color/color-07-cyan-12-teal.png");
	ColorHTMLBlueLightSteelBlue        .addFile(":/ico/22x22/color/color-08-blue-01-lightsteelblue.png");
	ColorHTMLBluePowderBlue            .addFile(":/ico/22x22/color/color-08-blue-02-powderblue.png");
	ColorHTMLBlueLightBlue             .addFile(":/ico/22x22/color/color-08-blue-03-lightblue.png");
	ColorHTMLBlueSkyBlue               .addFile(":/ico/22x22/color/color-08-blue-04-skyblue.png");
	ColorHTMLBlueLightSkyBlue          .addFile(":/ico/22x22/color/color-08-blue-05-lightskyblue.png");
	ColorHTMLBlueDeepSkyBlue           .addFile(":/ico/22x22/color/color-08-blue-06-deepskyblue.png");
	ColorHTMLBlueDodgerBlue            .addFile(":/ico/22x22/color/color-08-blue-07-dodgerblue.png");
	ColorHTMLBlueCornflowerBlue        .addFile(":/ico/22x22/color/color-08-blue-08-cornflowerblue.png");
	ColorHTMLBlueSteelBlue             .addFile(":/ico/22x22/color/color-08-blue-09-steelblue.png");
	ColorHTMLBlueRoyalBlue             .addFile(":/ico/22x22/color/color-08-blue-10-royalblue.png");
	ColorHTMLBlueBlue                  .addFile(":/ico/22x22/color/color-08-blue-11-blue.png");
	ColorHTMLBlueMediumBlue            .addFile(":/ico/22x22/color/color-08-blue-12-mediumblue.png");
	ColorHTMLBlueDarkBlue              .addFile(":/ico/22x22/color/color-08-blue-13-darkblue.png");
	ColorHTMLBlueNavy                  .addFile(":/ico/22x22/color/color-08-blue-14-navy.png");
	ColorHTMLBlueMidnightBlue          .addFile(":/ico/22x22/color/color-08-blue-15-midnightblue.png");
	ColorHTMLPurpleLavender            .addFile(":/ico/22x22/color/color-09-purple-01-lavender.png");
	ColorHTMLPurpleThistle             .addFile(":/ico/22x22/color/color-09-purple-02-thistle.png");
	ColorHTMLPurplePlum                .addFile(":/ico/22x22/color/color-09-purple-03-plum.png");
	ColorHTMLPurpleViolet              .addFile(":/ico/22x22/color/color-09-purple-04-violet.png");
	ColorHTMLPurpleOrchid              .addFile(":/ico/22x22/color/color-09-purple-05-orchid.png");
	ColorHTMLPurpleFuchsia             .addFile(":/ico/22x22/color/color-09-purple-06-fuchsia.png");
	ColorHTMLPurpleMagenta             .addFile(":/ico/22x22/color/color-09-purple-07-magenta.png");
	ColorHTMLPurpleMediumOrchid        .addFile(":/ico/22x22/color/color-09-purple-08-mediumorchid.png");
	ColorHTMLPurpleMediumPurple        .addFile(":/ico/22x22/color/color-09-purple-09-mediumpurple.png");
	ColorHTMLPurpleBlueViolet          .addFile(":/ico/22x22/color/color-09-purple-10-blueviolet.png");
	ColorHTMLPurpleDarkViolet          .addFile(":/ico/22x22/color/color-09-purple-11-darkviolet.png");
	ColorHTMLPurpleDarkOrchid          .addFile(":/ico/22x22/color/color-09-purple-12-darkorchid.png");
	ColorHTMLPurpleDarkMagenta         .addFile(":/ico/22x22/color/color-09-purple-13-darkmagenta.png");
	ColorHTMLPurplePurple              .addFile(":/ico/22x22/color/color-09-purple-14-purple.png");
	ColorHTMLPurpleIndigo              .addFile(":/ico/22x22/color/color-09-purple-15-indigo.png");
	ColorHTMLPurpleDarkSlateBlue       .addFile(":/ico/22x22/color/color-09-purple-16-darkslateblue.png");
	ColorHTMLPurpleSlateBlue           .addFile(":/ico/22x22/color/color-09-purple-17-slateblue.png");
	ColorHTMLPurpleMediumSlateBlue     .addFile(":/ico/22x22/color/color-09-purple-18-mediumslateblue.png");
	ColorHTMLWhiteWhite                .addFile(":/ico/22x22/color/color-10-white-01-white.png");
	ColorHTMLWhiteSnow                 .addFile(":/ico/22x22/color/color-10-white-02-snow.png");
	ColorHTMLWhiteHoneydew             .addFile(":/ico/22x22/color/color-10-white-03-honeydew.png");
	ColorHTMLWhiteMintCream            .addFile(":/ico/22x22/color/color-10-white-04-mintcream.png");
	ColorHTMLWhiteAzure                .addFile(":/ico/22x22/color/color-10-white-05-azure.png");
	ColorHTMLWhiteAliceBlue            .addFile(":/ico/22x22/color/color-10-white-06-aliceblue.png");
	ColorHTMLWhiteGhostWhite           .addFile(":/ico/22x22/color/color-10-white-07-ghostwhite.png");
	ColorHTMLWhiteWhiteSmoke           .addFile(":/ico/22x22/color/color-10-white-08-whitesmoke.png");
	ColorHTMLWhiteSeashell             .addFile(":/ico/22x22/color/color-10-white-09-seashell.png");
	ColorHTMLWhiteBeige                .addFile(":/ico/22x22/color/color-10-white-10-beige.png");
	ColorHTMLWhiteOldLace              .addFile(":/ico/22x22/color/color-10-white-11-oldlace.png");
	ColorHTMLWhiteFloralWhite          .addFile(":/ico/22x22/color/color-10-white-12-floralwhite.png");
	ColorHTMLWhiteIvory                .addFile(":/ico/22x22/color/color-10-white-13-ivory.png");
	ColorHTMLWhiteAntiqueWhite         .addFile(":/ico/22x22/color/color-10-white-14-antiquewhite.png");
	ColorHTMLWhiteLinen                .addFile(":/ico/22x22/color/color-10-white-15-linen.png");
	ColorHTMLWhiteLavenderBlush        .addFile(":/ico/22x22/color/color-10-white-16-lavenderblush.png");
	ColorHTMLWhiteMistyRose            .addFile(":/ico/22x22/color/color-10-white-17-mistyrose.png");
	ColorHTMLGrayGainsboro             .addFile(":/ico/22x22/color/color-11-gray-01-gainsboro.png");
	ColorHTMLGrayLightGray             .addFile(":/ico/22x22/color/color-11-gray-02-lightgray.png");
	ColorHTMLGraySilver                .addFile(":/ico/22x22/color/color-11-gray-03-silver.png");
	ColorHTMLGrayDarkGray              .addFile(":/ico/22x22/color/color-11-gray-04-darkgray.png");
	ColorHTMLGrayGray                  .addFile(":/ico/22x22/color/color-11-gray-05-gray.png");
	ColorHTMLGrayDimGray               .addFile(":/ico/22x22/color/color-11-gray-06-dimgray.png");
	ColorHTMLGrayLightSlateGray        .addFile(":/ico/22x22/color/color-11-gray-07-lightslategray.png");
	ColorHTMLGraySlateGray             .addFile(":/ico/22x22/color/color-11-gray-08-slategray.png");
	ColorHTMLGrayDarkSlateGray         .addFile(":/ico/22x22/color/color-11-gray-09-darkslategray.png");
	ColorHTMLGrayBlack                 .addFile(":/ico/22x22/color/color-11-gray-10-black.png");
}
